// This file is provided under The MIT License as part of Steamworks.NET.
// Copyright (c) 2013-2016 Riley Labrecque
// Please see the included LICENSE.txt for additional information.

// Changes to this file will be reverted when you update Steamworks.NET

namespace Steamworks {
	[System.Serializable]
	public struct UGCHandle_t : System.IEquatable<UGCHandle_t>, System.IComparable<UGCHandle_t> {
		public static readonly UGCHandle_t Invalid = new UGCHandle_t(0xffffffffffffffff);
		public ulong m_UGCHandle;

		public UGCHandle_t(ulong value) {
			m_UGCHandle = value;
		}

		public override string ToString() {
			return m_UGCHandle.ToString();
		}

		public override bool Equals(object other) {
			return other is UGCHandle_t && this == (UGCHandle_t)other;
		}

		public override int GetHashCode() {
			return m_UGCHandle.GetHashCode();
		}

		public static bool operator ==(UGCHandle_t x, UGCHandle_t y) {
			return x.m_UGCHandle == y.m_UGCHandle;
		}

		public static bool operator !=(UGCHandle_t x, UGCHandle_t y) {
			return !(x == y);
		}

		public static explicit operator UGCHandle_t(ulong value) {
			return new UGCHandle_t(value);
		}

		public static explicit operator ulong(UGCHandle_t that) {
			return that.m_UGCHandle;
		}

		public bool Equals(UGCHandle_t other) {
			return m_UGCHandle == other.m_UGCHandle;
		}

		public int CompareTo(UGCHandle_t other) {
			return m_UGCHandle.CompareTo(other.m_UGCHandle);
		}
	}
}
